' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa DownloadDB jest uywana do przesyania pozycji do pobrania (zarwno pojedynczych egzemplarzy jak i list) do i z bazy danych.
''' </summary>
Public Class DownloadDB

  ''' <summary>
  ''' ukryj konstruktor aby unikn tworzenia egzemplarzy klasy DownloadDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Pobiera z bazy danych list plikw do pobrania, w oparciu o identyfikator kategorii, do ktrej odnosz si pliki.
  ''' </summary>
  ''' <param name="categoryId">Identyfikator kategorii w bazie danych, dla ktrej maj by zwrcone pliki.</param>
  Public Shared Function GetDownloadList(ByVal categoryId As Integer) As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocDownloadSelectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        If categoryId = -1 Then ' pobierz wszystkie pliki w Sekcji Administracyjnej 
          myCommand.Parameters.AddWithValue("@categoryId", DBNull.Value)
        Else ' pobierz pliki dla okreslonej kategorii
          myCommand.Parameters.AddWithValue("@categoryId", categoryId)
        End If

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()
        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy egzemplarz pozycji <see cref="Download" />.
  ''' </summary>
  ''' <param name="id">Identyfikator downloadu w bazie danych.</param>
  ''' <returns>Egzemplarz klasy <see cref="Download" />.</returns>
  Public Shared Function [Get](ByVal id As Integer) As Download
    Dim myDownload As Download = Nothing
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand("sprocDownloadSelectSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@id", id)

        myConnection.Open()
        Using myReader As SqlDataReader = myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          If myReader.Read() Then
            myDownload = New Download(myReader.GetInt32(myReader.GetOrdinal("Id")))
            myDownload.Title = myReader.GetString(myReader.GetOrdinal("Title"))
            myDownload.Description = myReader.GetString(myReader.GetOrdinal("Description"))
            myDownload.CategoryId = myReader.GetInt32(myReader.GetOrdinal("CategoryId"))
            myDownload.DownloadUrl = myReader.GetString(myReader.GetOrdinal("DownloadUrl"))
          End If
          myReader.Close()
        End Using
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
    Return myDownload
  End Function

  ''' <summary>
  '''  Usuwa Download z bazy danych.
  ''' </summary>
  ''' <param name="id">Identyfikator downloadu w bazie danych.</param>
  Public Shared Sub Delete(ByVal id As Integer)
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocDownloadDeleteSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      myCommand.Parameters.AddWithValue("@id", id)

      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub


  ''' <summary>
  '''  Zapisuje Download w bazie danych.
  ''' </summary>
  ''' <param name="myDownload">Egzemplarz klasy <see cref="Download" />.</param>
  Public Shared Sub Save(ByVal myDownload As Download)
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocDownloadInsertUpdateSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      If myDownload.Id > 0 Then
        myCommand.Parameters.AddWithValue("@id", myDownload.Id)
      Else
        myCommand.Parameters.AddWithValue("@id", DBNull.Value)
      End If
      myCommand.Parameters.AddWithValue("@title", myDownload.Title)
      myCommand.Parameters.AddWithValue("@description", myDownload.Description)
      myCommand.Parameters.AddWithValue("@categoryId", myDownload.CategoryId)
      myCommand.Parameters.AddWithValue("@downloadUrl", myDownload.DownloadUrl)
      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub

End Class
